//*************************************************************************************************
//
//	Description:
//		Shaders used for displaying debug triangles
//		
//		
//
//	<P> Copyright (c) 2006 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Matt Hobbs
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		Matt            22/12/2006	0.1						Created
//		TMann						9/1/2007		0.2						PS3/WinGL
//		TNettleship			10/23/2007	0.3						Converted to on-load rendermode behaviour binding.
//
//	<TABLE>
//
//*************************************************************************************************

#include "stddefs.fxh"

//
// Transforms
//
float4x4 worldviewproj : WorldViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
	bool dynamic = true;
>;




//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

struct VSINPUT
{
	float3 position : POSITION;												
	float4 colour : COLOR;
};

struct VSOUTPUT
{
	float4 position		: POSITION;												
	float4 colour		: COLOR0;												
};



//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT triVertexShader( VSINPUT _input )
{
	VSOUTPUT _output = ( VSOUTPUT )0;
	
	_output.position = mul( float4( _input.position, 1.0f ), worldviewproj );
	_output.colour = _input.colour;
		
	return _output;
}


//-----------------------------------------------------------------------
//
// Fragment Shader(s)
//

struct PSINPUT
{
	float4 colour : COLOR0;														
};

struct PSOUTPUT
{
	COLOUR_OUTPUT_TYPE colour : COLOR0;
};



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT triFragmentShader( PSINPUT _input )
{
	PSOUTPUT _output;	

	// pass thru
	_output.colour = _input.colour;
	
	return _output;
}



//-----------------------------------------------------------------------
//
// Technique(s)
//

technique DbgTriangles
<
	bool supportsSpecialisedLighting = false;
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "DbgTriangles";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
		ZEnable = 1;
		ZWriteEnable = true;
		AlphaBlendEnable = false;
		
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx triVertexShader();
		PixelShader = compile sce_fp_rsx triFragmentShader();
#else		
		VertexShader = compile vs_3_0 triVertexShader();
		PixelShader = compile ps_3_0 triFragmentShader();
#endif		
	}
}


technique DbgTrianglesAlpha
<
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "DbgTrianglesAlpha";
	int    normalDeferredID		= 2;
>
{
	pass Pass0
	{
		ZEnable = 1;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		
#if defined (_PS3_)
		BlendFunc=int2(SrcAlpha, InvSrcAlpha);
		BlendEquation=int(FuncAdd);
		VertexShader = compile sce_vp_rsx triVertexShader();
		PixelShader = compile sce_fp_rsx triFragmentShader();
#else		
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		BlendOp = ADD;	
		VertexShader = compile vs_3_0 triVertexShader();
		PixelShader = compile ps_3_0 triFragmentShader();
#endif		
	}
}

technique DbgTrianglesAlphaAdd
<
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "DbgTrianglesAlphaAdd";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
		ZEnable = 1;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		
#if defined (_PS3_)
		BlendFunc=int2(SrcAlpha, One);
		BlendEquation=int(FuncAdd);
		VertexShader = compile sce_vp_rsx triVertexShader();
		PixelShader = compile sce_fp_rsx triFragmentShader();
#else		
		SrcBlend = SRCALPHA;
		DestBlend = ONE;
		BlendOp = ADD;	
		VertexShader = compile vs_3_0 triVertexShader();
		PixelShader = compile ps_3_0 triFragmentShader();
#endif		
	}
}

technique DbgTrianglesAlphaAdd_NoZTest
<
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "DbgTrianglesAlphaAdd_NoZTest";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
		ZEnable = 0;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		
#if defined (_PS3_)
		BlendFunc=int2(SrcAlpha, One);
		BlendEquation=int(FuncAdd);
		VertexShader = compile sce_vp_rsx triVertexShader();
		PixelShader = compile sce_fp_rsx triFragmentShader();
#else		
		SrcBlend = SRCALPHA;
		DestBlend = ONE;
		BlendOp = ADD;	
		VertexShader = compile vs_3_0 triVertexShader();
		PixelShader = compile ps_3_0 triFragmentShader();
#endif		
	}
}

technique DbgTrianglesAlphaSubtract
<
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "DbgTrianglesAlphaSubtract";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
		ZEnable = 1;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		
#if defined (_PS3_)
		BlendFunc=int2(One, SrcAlpha);
		BlendEquation=int(FuncSubtract);
		VertexShader = compile sce_vp_rsx triVertexShader();
		PixelShader = compile sce_fp_rsx triFragmentShader();
#else		
		SrcBlend = SRCALPHA;
		DestBlend = ONE;
		BlendOp = REVSUBTRACT;	
		VertexShader = compile vs_3_0 triVertexShader();
		PixelShader = compile ps_3_0 triFragmentShader();
#endif
	}
}

technique DbgTrianglesAlphaSubtract_NoZTest
<
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "DbgTrianglesAlphaSubtract_NoZTest";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
		ZEnable = 0;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		
#if defined (_PS3_)
		BlendFunc=int2(One, SrcAlpha);
		BlendEquation=int(FuncSubtract);
		VertexShader = compile sce_vp_rsx triVertexShader();
		PixelShader = compile sce_fp_rsx triFragmentShader();
#else		
		SrcBlend = SRCALPHA;
		DestBlend = ONE;
		BlendOp = REVSUBTRACT;	
		VertexShader = compile vs_3_0 triVertexShader();
		PixelShader = compile ps_3_0 triFragmentShader();
#endif
	}
}


technique DbgTriangles_NoColour
<
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "DbgTriangles_NoColour";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
		ZEnable = 1;
		ZWriteEnable = false;
		AlphaBlendEnable = false;
		
#if defined (_PS3_)
		CullFaceEnable=false;
		VertexShader = compile sce_vp_rsx triVertexShader();
		PixelShader = compile sce_fp_rsx triFragmentShader();
#else		
		CullMode = None;
		VertexShader = compile vs_3_0 triVertexShader();
		PixelShader = compile ps_3_0 triFragmentShader();
#endif		
	}
}
